import { currentDiagram } from "./components/bottomStatusBar_controller.js";
import initAddTablesDialog from "./dialogs/addTables_controller.js";
import GUID from "./components/guid.js";
import initTableJoinDialog from "./dialogs/tableJoin_controller.js";
let mRelationDiagram = null;
let mRelationModel = null;
let mDatabaseLink = null;
let mLayuiObject = null;

let svgns = "http://www.w3.org/2000/svg";
let svger = null;

const TITLE_HEIGHT1 = 28;
const TITLE_HEIGHT2 = 46;
const FIELD_HEIGHT = 24;
const MORE_HEIGHT = 18;
const RESIZE_HEIGHT = 3;

let dragType;//"object","folder"
let dragObjectStr;

let useCommentAsName = false;

/**
 * 0:划线，1:改变位置
 */
let dragTypeEnum = -1;
let fieldDragObject = {};
let blockDragObject = {};

bindEvent();
function initRelationDiagram(relationDiagram, relationModel, databaseLink, layuiObject) {

    let systemSettings = new OrganizationSystemSettings();
    var succ = function () {
        if ("1" == systemSettings.item("useCommentAsName").systemSettingValue) {
            useCommentAsName = true;
        }
    };
    var fail = function (errorStatus, msg) {
        $Utils.loading.close();
        $Utils.openWindow.failWindow("获取组织设置", errorStatus, msg);
    };
    systemSettings.getItems(false, succ, fail);

    mRelationDiagram = relationDiagram;
    mRelationModel = relationModel;
    mDatabaseLink = databaseLink;
    mLayuiObject = layuiObject;
    currentDiagram(mRelationDiagram.relationDiagramName || "", mRelationDiagram.tableBlocks.count(), mRelationDiagram.tableJoins.count());
    clearDiagramCanvas();


    let daigramCanvas = document.getElementById("daigramCanvas");
    // let svgcontainer = $("#daigramCanvas");


    svger = document.createElementNS(svgns, "svg");
    svger.setAttribute("class", "svg-map");
    svger.setAttribute("z-index", "-1");
    svger.setAttribute("width", daigramCanvas.clientWidth);
    svger.setAttribute("height", daigramCanvas.clientHeight);
    svger.setAttribute("viewBox", "0 0 " + daigramCanvas.clientWidth + " " + daigramCanvas.clientHeight);
    daigramCanvas.appendChild(svger);

    let blockBorderStr = `<div id="blockBorder" class="box-hide"></div>`
    $("#daigramCanvas").append(blockBorderStr);
    $("#daigramCanvas").append("<div class='aaaaa' style='position:absolute; left:0; top:0; right:0; bottom:0;'></div>");

    $("#btnAddTable").addClass("button-color");
    $("#btnAddTableJoin").addClass("button-color");

    //把relationDiagram画到画布上
    loadRelationDiagram();

}

//
function loadRelationDiagram() {
    loadTableBlocks();
    loadTableJoins();
}

function loadTableBlocks() {
    for (let i = 0; i < mRelationDiagram.tableBlocks.count(); i++) {
        let tableBlock = mRelationDiagram.tableBlocks.item(i);
        drawTableBlock(tableBlock);
        // break;
    }
}
function drawTableBlock(tableBlock) {
    let table = tableBlock.table;
    let stringBuilder = "";
    let haveHideField = false;
    // let haveNotvisible = false;
    let curHeight = 0;
    let maxFieldCount = 0;
    let showFieldCount = 0;

    let titleHieght = TITLE_HEIGHT1;
    let realName = "";
    if (tableBlock.tableAlias == tableBlock.table.tableName) {
        titleHieght = TITLE_HEIGHT1;
        realName = "";
    } else {
        titleHieght = TITLE_HEIGHT2;
        realName = `<br>（${tableBlock.table.tableName}）`;
    }
    curHeight += titleHieght;

    for (let j = 0; j < table.tableFields.count(); j++) {
        if (table.tableFields.item(j).visible) {
            let tableField = table.tableFields.item(j);
            maxFieldCount++;
            curHeight += FIELD_HEIGHT;
            if (curHeight > tableBlock.height) {
                curHeight -= FIELD_HEIGHT;
                stringBuilder += `<li class="field" style="height:${FIELD_HEIGHT}px;display:none;" draggable="true" comment="${tableField.commemt ? tableField.commemt : ""}" dataType="${tableField.dataType}">${tableField.fieldName}</li>`;
                haveHideField = true;
            } else {
                showFieldCount++;
                stringBuilder += `<li class="field" style="height:${FIELD_HEIGHT}px;" draggable="true" comment="${tableField.commemt ? tableField.commemt : ""}" dataType="${tableField.dataType}">${tableField.fieldName}</li>`;
            }
        } else {
            haveHideField = true;
            // haveNotvisible = true;
        }
    }
    if (haveHideField) {
        stringBuilder += `<li class="more" style="height:${MORE_HEIGHT}px;font-size: 26px;text-align: center;cursor:default;line-height: 3px;">...</li>`;
        curHeight += MORE_HEIGHT;
    }
    // if(haveNotvisible){
    //     maxHeight += MORE_HEIGHT;
    // }
    stringBuilder += `<li class="resize" style="height:${RESIZE_HEIGHT}px;cursor:ns-resize;background-color: gray;"></li>`;
    curHeight += RESIZE_HEIGHT;
    tableBlock.height = curHeight;
    // maxHeight += RESIZE_HEIGHT;

    let strHtml = `<div class="table-block" draggable="true" id="${tableBlock.tableBlockID}" maxFieldCount="${maxFieldCount}" showFieldCount="${showFieldCount}" style="left: ${tableBlock.x}px; top: ${tableBlock.y}px;">
            <h5 style="height:${titleHieght}px;">${tableBlock.tableAlias}${realName}</h5>
            <ul>${stringBuilder}</ul>
        </div>`;
    $("#daigramCanvas").append(strHtml);
}

function loadTableJoins() {

    for (let i = 0; i < mRelationDiagram.tableJoins.count(); i++) {
        let tableJoin = mRelationDiagram.tableJoins.item(i);
        drawTableJoin(tableJoin);
    }
}
function drawTableJoin(tableJoin, path) {
    let canvasTop = $("#daigramCanvas").offset().top;
    let canvasLeft = $("#daigramCanvas").offset().left;
    let tableBlock1 = mRelationDiagram.tableBlocks.getTableBlockByAlias(tableJoin.table1Alias);
    let tableBlock2 = mRelationDiagram.tableBlocks.getTableBlockByAlias(tableJoin.table2Alias);
    let eleBlock1 = $("#" + tableBlock1.tableBlockID);
    let eleBlock2 = $("#" + tableBlock2.tableBlockID);
    let width1 = eleBlock1.width() + 2;//边框宽度为1
    let top1 = eleBlock1.offset().top - canvasTop + getTableFieldHeight(tableJoin.table1Alias, tableJoin.table1Field1, eleBlock1.height() + 1);//上边框1+标题上padding4
    let top12 = -1;
    if (tableJoin.table1Field2) {
        top12 = eleBlock1.offset().top - canvasTop + getTableFieldHeight(tableJoin.table1Alias, tableJoin.table1Field2, eleBlock1.height() + 1);
    }
    let left1 = eleBlock1.offset().left - canvasLeft;
    let width2 = eleBlock2.width() + 2;
    let top2 = eleBlock2.offset().top - canvasTop + getTableFieldHeight(tableJoin.table2Alias, tableJoin.table2Field1, eleBlock2.height() + 1);
    let top22 = -1;
    if (tableJoin.table2Field2) {
        top22 = eleBlock2.offset().top - canvasTop + getTableFieldHeight(tableJoin.table2Alias, tableJoin.table2Field2, eleBlock2.height() + 1);
    }
    let left2 = eleBlock2.offset().left - canvasLeft;

    let leftPoint = {};
    let leftPoint2 = null;
    let rightPoint = {};
    let rightPoint2 = null;
    let leftMore = false;
    let rightMore = false;
    if (left1 < left2) {
        leftPoint.x = left1 + width1;
        leftPoint.y = top1;
        if (top12 != -1) {
            leftPoint2 = {};
            leftPoint2.x = left1 + width1;
            leftPoint2.y = top12;
        }

        rightPoint.x = left2;
        rightPoint.y = top2;
        if (top22 != -1) {
            rightPoint2 = {};
            rightPoint2.x = left2;
            rightPoint2.y = top22;
        }

        if (tableJoin.cardinality == 1) {
            rightMore = true;
        } else if (tableJoin.cardinality == 2) {
            leftMore = true;
        } else if (tableJoin.cardinality == 3) {
            leftMore = true;
            rightMore = true;
        }

    } else {
        leftPoint.x = left2 + width2;
        leftPoint.y = top2;
        if (top22 != -1) {
            leftPoint2 = {};
            leftPoint2.x = left2 + width2;
            leftPoint2.y = top22;
        }

        rightPoint.x = left1;
        rightPoint.y = top1;
        if (top12 != -1) {
            rightPoint2 = {};
            rightPoint2.x = left1;
            rightPoint2.y = top12;
        }

        if (tableJoin.cardinality == 1) {
            leftMore = true;
        } else if (tableJoin.cardinality == 2) {
            rightMore = true;
        } else if (tableJoin.cardinality == 3) {
            leftMore = true;
            rightMore = true;
        }

    }
    if (!path) {
        path = document.createElementNS(svgns, "path");
    }
    let pathBuilder = [];
    pathBuilder.push("M " + leftPoint.x + " " + leftPoint.y + ",L" + (leftPoint.x + 10) + " " + leftPoint.y);
    if (leftMore) {
        pathBuilder.push("M " + leftPoint.x + " " + (leftPoint.y + 5) + ",L" + (leftPoint.x + 10) + " " + leftPoint.y);
        pathBuilder.push("M " + leftPoint.x + " " + (leftPoint.y - 5) + ",L" + (leftPoint.x + 10) + " " + leftPoint.y);
    }
    if (leftPoint2) {
        pathBuilder.push("M " + leftPoint2.x + " " + leftPoint2.y + ",L" + (leftPoint2.x + 10) + " " + leftPoint2.y);
        if (leftMore) {
            pathBuilder.push("M " + leftPoint2.x + " " + (leftPoint2.y + 5) + ",L" + (leftPoint2.x + 10) + " " + leftPoint2.y);
            pathBuilder.push("M " + leftPoint2.x + " " + (leftPoint2.y - 5) + ",L" + (leftPoint2.x + 10) + " " + leftPoint2.y);
        }
    }
    if (leftPoint2 || rightPoint2) {
        //确定中点
        let centerPoint = {};
        centerPoint.x = (leftPoint.x + rightPoint.x) / 2;
        let sum = 0;
        let count = 2;
        sum += leftPoint.y;
        sum += rightPoint.y;
        if (leftPoint2 && rightPoint2) {
            sum += leftPoint2.y;
            count++;
            sum += rightPoint2.y;
            count++;
        } else if (leftPoint2) {
            sum += leftPoint2.y;
            sum += rightPoint.y;
            count += 2;
        } else if (rightPoint2) {
            sum += rightPoint2.y;
            sum += leftPoint.y;
            count += 2;
        }

        centerPoint.y = sum / count;
        pathBuilder.push("L" + centerPoint.x + " " + centerPoint.y);
        if (leftPoint2) {
            pathBuilder.push("L" + (leftPoint.x + 10) + " " + leftPoint.y);
            pathBuilder.push("M" + centerPoint.x + " " + centerPoint.y);
        }
        if (rightPoint2) {
            pathBuilder.push("L" + (rightPoint2.x - 10) + " " + rightPoint2.y);
            pathBuilder.push("M" + centerPoint.x + " " + centerPoint.y);
        }
    }
    pathBuilder.push("L" + (rightPoint.x - 10) + " " + rightPoint.y);

    pathBuilder.push("L" + rightPoint.x + " " + rightPoint.y);
    if (rightMore) {
        pathBuilder.push("M" + (rightPoint.x - 10) + " " + rightPoint.y + ",L" + rightPoint.x + " " + (rightPoint.y + 5));
        pathBuilder.push("M" + (rightPoint.x - 10) + " " + rightPoint.y + ",L" + rightPoint.x + " " + (rightPoint.y - 5));
    }
    if (rightPoint2) {
        pathBuilder.push("M" + (rightPoint2.x - 10) + " " + rightPoint2.y + ",L" + rightPoint2.x + " " + rightPoint2.y);
        if (rightMore) {
            pathBuilder.push("M" + (rightPoint2.x - 10) + " " + rightPoint2.y + ",L" + rightPoint2.x + " " + (rightPoint2.y + 5));
            pathBuilder.push("M" + (rightPoint2.x - 10) + " " + rightPoint2.y + ",L" + rightPoint2.x + " " + (rightPoint2.y - 5));
        }
    }
    path.setAttribute("d", pathBuilder.join(","));
    path.setAttribute("class", "table-join");
    path.setAttribute("id", tableJoin.tableJoinID);
    path.setAttribute("stroke", "black");
    path.setAttribute("stroke-width", "1");
    path.setAttribute("fill", "none");
    svger.appendChild(path);
}
/**
 * 清除画板
 */
function clearDiagramCanvas() {
    $("#daigramCanvas").html("");
}

function getTableFieldHeight(tableAlias, fieldName, height) {

    let tableBlock = mRelationDiagram.tableBlocks.getTableBlockByAlias(tableAlias);
    let y = 1;//上边框高度为1
    if (tableBlock.tableAlias == tableBlock.table.tableName) {
        y += TITLE_HEIGHT1;
    } else {
        y += TITLE_HEIGHT2;
    }
    let tableFields = tableBlock.table.tableFields;
    let haveField = false;
    for (let i = 0; i < tableFields.count(); i++) {
        if (tableFields.item(i).visible) {
            y += FIELD_HEIGHT;
            if (y > height) {
                y = height - RESIZE_HEIGHT - MORE_HEIGHT / 2;
                return y;
            }
            if (fieldName == tableFields.item(i).fieldName) {
                y -= FIELD_HEIGHT / 2;
                haveField = true;
                break;
            }
        }
    }
    if (!haveField) {
        y += MORE_HEIGHT / 2;
    }
    if (y > height) {
        y = height - RESIZE_HEIGHT - MORE_HEIGHT / 2;
    }
    return y;
}

/**
 * 计算Diagram大小，返回Size对象{width,height}
 */
function calculateDiagram() {

}


let lastMousedownTime;
let selectedBlockView;//选中的tableBlock
let selectedJoinView;//选中的tableBlock
function bindEvent() {
    //#region 按钮事件
    $("#btnAddTable").click(function () {
        let tables = new Tables();
        if (mDatabaseLink != null) {
            tables.getItems(mDatabaseLink.dataSourceID, false, function () {
                $.ajax({
                    url: "dialogs/addTables.html",
                    type: 'GET',
                    success: function (data) {
                        layer.open({
                            type: 1,
                            title: ["选择表", "font-size: 14px"],
                            btn: false,
                            resize: false,
                            area: ["480px", "640px"],
                            content: data,
                            success: function (layero, index) {
                                debugger
                                initAddTablesDialog(index, mLayuiObject, tables, function (selectedTables) {
                                    //获取tableFields
                                    insertTables(selectedTables);
                                    return true;
                                });
                            }
                        });
                    }
                });
            }, function (errorMsg) { });
        } else {
            alert("缺少数据库连接。");
        }
    });

    $("#btnAddTableJoin").click(function () {
        $.ajax({
            url: "dialogs/tableJoin.html",
            type: "GET",
            success: function (data) {
                layer.open({
                    type: 1,
                    title: ["表连接属性", "font-size: 14px"],
                    btn: false,
                    resize: false,
                    area: ["500px", "700px"],
                    content: data,
                    success: function (layero, index) {
                        initTableJoinDialog(index, mLayuiObject, 0, new TableJoin(), mRelationDiagram.tableBlocks, mDatabaseLink, function () {

                        })
                    }
                });
            }
        });
    });

    $("#btnTableJoinsAttribute").click(function () {
        $.ajax({
            url: "dialogs/tableJoin.html",
            type: "GET",
            success: function (data) {
                layer.open({
                    type: 1,
                    title: ["表连接属性", "font-size: 14px"],
                    btn: false,
                    resize: false,
                    area: ["500px", "700px"],
                    content: data,
                    success: function (layero, index) {
                        let joinID = selectedJoinView.attr("id");
                        let tableJoin = mRelationDiagram.tableJoins.item(joinID);
                        initTableJoinDialog(index, mLayuiObject, 1, tableJoin, mRelationDiagram.tableBlocks, mDatabaseLink, function () {
                            //重画tableJoin
                            drawTableJoin(tableJoin, $("#" + tableJoin.tableJoinID)[0]);
                            return true;
                        })
                    }
                });
            }
        });
    });
    $("#btnDeleteTableOrTableJoins").click(function () {
        if (selectedJoinView) {
            //弹出询问框
            layer.open({
                type: 0,
                title: "删除表连接",
                closeBtn: 1,
                shadeClose: true,
                resize: false,
                area: ["480px", "270px"],
                skin: "delete-window",
                content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>" + "是否删除表连接？" + "</div></div>",
                btn: ["是", "否"],
                // success: function(layero,index){
                //     $(layero).find('.layui-layer-content').css('height','137px');
                // },
                yes: function (index, layero) {
                    let joinID = selectedJoinView.attr("id");
                    let tableJoin = mRelationDiagram.tableJoins.item(joinID);
                    mRelationDiagram.tableJoins.remove(tableJoin);
                    selectedJoinView.remove();
                    selectedJoinView = null;

                    layer.close(index);
                }
            });
        } else if (selectedBlockView) {
            let blockID = selectedBlockView.attr("id");
            let tableBlock = mRelationDiagram.tableBlocks.item(blockID);
            layer.open({
                type: 0,
                title: "删除表块",
                closeBtn: 1,
                shadeClose: true,
                resize: false,
                area: ["480px", "270px"],
                skin: "delete-window",
                content: `<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除表 ${tableBlock.tableAlias} 以及所有与之相连的表连接吗？</div></div>`,
                btn: ["是", "否"],
                // success: function(layero,index){
                //     $(layero).find('.layui-layer-content').css('height','137px');
                // },
                yes: function (index, layero) {
                    mRelationDiagram.tableBlocks.remove(tableBlock);
                    selectedBlockView.remove();
                    selectedBlockView = null;

                    let tableAlias = tableBlock.tableAlias;
                    for (let i = mRelationDiagram.tableJoins.count() - 1; i >= 0; i--) {
                        let tableJoin = mRelationDiagram.tableJoins.item(i);
                        if (tableJoin.table1Alias == tableAlias || tableJoin.table2Alias == tableAlias) {
                            $("#" + tableJoin.tableJoinID).remove();
                            mRelationDiagram.tableJoins.remove(tableJoin);
                        }
                    }

                    layer.close(index);
                }
            });
        }
    });
    //#endregion

    $(".canvas-box").click(function () {
        // currentDiagram(mRelationDiagram.relationDiagramName, mRelationDiagram.tableBlocks.count() + i, mRelationDiagram.tableJoins.count() + i);
        // i++;
    });
    $(".canvas-box").on("mousedown", function (e) {
        // console.log("mousedown");
        unselectBlock();
    });
    $(".canvas-box").on("mousedown", ".table-join", function (e) {
        // console.log("table-join mousedown");
        selectJoin($(this));
    });
    $(".canvas-box").on("dragstart", ".table-block ul li.field", function (e) {
        // console.log("dragstart");
        let crt = this.cloneNode(true);
        crt.style.backgroundColor = "red";
        e.originalEvent.dataTransfer.setDragImage(crt, 0, 0);

        dragTypeEnum = 0;
        dragObjectStr = "";
        dragType = "";
        fieldDragObject = {};
        fieldDragObject.canvasTop = $("#daigramCanvas").offset().top;
        fieldDragObject.canvasLeft = $("#daigramCanvas").offset().left;

        fieldDragObject.tempPath = document.createElementNS(svgns, "path");
        fieldDragObject.tempPath.setAttribute("stroke", "black");
        fieldDragObject.tempPath.setAttribute("stroke-width", "1");
        fieldDragObject.tempPath.setAttribute("fill", "none");
        fieldDragObject.fieldView = $(this);
        selectBlock($(this).parent().parent())
        let position = selectedBlockView.position();
        fieldDragObject.blockID = selectedBlockView.attr("id");
        fieldDragObject.tableBlock = mRelationDiagram.tableBlocks.item(fieldDragObject.blockID);

        fieldDragObject.leftX = position.left;
        fieldDragObject.rightX = position.left + selectedBlockView.width() + 2;//边框宽度为1
        fieldDragObject.centerX = position.left + selectedBlockView.width() / 2 + 1;//边框宽度为1
        fieldDragObject.startY = position.top + $(this).position().top + FIELD_HEIGHT / 2;
        fieldDragObject.field = $(this).html();
        let tableField = new TableField();
        tableField.fieldName = fieldDragObject.fieldView.html();
        tableField.comment = fieldDragObject.fieldView.attr("comment");
        tableField.dataType = fieldDragObject.fieldView.attr("dataType");
        tableField.visible = true;

        let businessObject = createBOByTableField(tableField, fieldDragObject.tableBlock.tableAlias);
        dragObjectStr = JSON.stringify(businessObject);
        dragType = "object";

        e.originalEvent.dataTransfer.setData(dragType, dragObjectStr);

        fieldDragObject.drawLine = true;
        e.stopPropagation();
    });
    $("body").on("dragend", ".table-block ul li.field", function (e) {
        // console.log("field dragend");
        fieldDragObject.drawLine = false;
        fieldDragObject.tempPath.remove();
        dragTypeEnum = -1;
    });
    $(".canvas-box")[0].ondragover = function (e) {
        if (dragTypeEnum == 0) {
            if (fieldDragObject.drawLine) {
                // console.log("field dragover");
                let stringBuilder = [];
                let X = e.pageX - fieldDragObject.canvasLeft;
                let Y = e.pageY - fieldDragObject.canvasTop;
                if (X < 0 && Y > 0) {
                    //生成BusinessObject


                } else {
                    if (X < fieldDragObject.centerX) {
                        stringBuilder.push("M " + fieldDragObject.leftX + " " + fieldDragObject.startY + ",L " + (fieldDragObject.leftX - 10) + " " + fieldDragObject.startY);
                    } else {
                        stringBuilder.push("M " + fieldDragObject.rightX + " " + fieldDragObject.startY + ",L " + (fieldDragObject.rightX + 10) + " " + fieldDragObject.startY);
                    }
                    stringBuilder.push("L " + X + " " + Y);
                    fieldDragObject.tempPath.setAttribute("d", stringBuilder.join(","));
                    svger.appendChild(fieldDragObject.tempPath);
                }
            }

        } else if (dragTypeEnum == 1) {
            // blockDragObject.blockBorder.css({
            //     "left": blockDragObject.position.left + (e.pageX - blockDragObject.startX),
            //     "top": blockDragObject.position.top + (e.pageY - blockDragObject.startY),
            // });
        }
        e.preventDefault();
    };
    $(".canvas-box")[0].ondrop = function (e) {
        if (dragTypeEnum == 0) {
            // console.log("field drop");
            fieldDragObject.tempPath.remove();
            let field2View = $(e.target);
            //如果当前位置是表字段，生成tableJoin
            if (field2View.hasClass("field")) {
                let alias1 = fieldDragObject.tableBlock.tableAlias;
                let field1 = fieldDragObject.field;
                let blockID2 = field2View.parent().parent().attr("id");
                let block2 = mRelationDiagram.tableBlocks.item(blockID2);
                let alias2 = block2.tableAlias;
                let field2 = field2View.html();
                if (alias1 != alias2) {
                    let tableJoin = new TableJoin();
                    tableJoin.tableJoinID = new GUID().newGUID();
                    tableJoin.table1Alias = alias1;
                    tableJoin.table2Alias = alias2;
                    tableJoin.table1Field1 = field1;
                    tableJoin.table2Field1 = field2;
                    tableJoin.joinType = 0;
                    tableJoin.expression = `${alias1}.${field1} = ${alias2}.${field2}`;
                    mRelationDiagram.tableJoins.add(tableJoin);
                    drawTableJoin(tableJoin);
                }
            }
        } else if (dragTypeEnum == 1) {
            // console.log("block drop");
            let blockID = selectedBlockView.attr('id');
            let tableBlock = mRelationDiagram.tableBlocks.item(blockID);
            let endX = e.pageX - blockDragObject.canvasLeft;
            let endY = e.pageY - blockDragObject.canvasTop;

            tableBlock.x = endX - blockDragObject.titleLeft;
            tableBlock.y = endY - blockDragObject.titleTop;
            selectedBlockView.css({
                "left": tableBlock.x,
                "top": tableBlock.y,
            });
            //重新绘制相关的tableJoins
            for (let i = 0; i < mRelationDiagram.tableJoins.count(); i++) {
                let tableJoin = mRelationDiagram.tableJoins.item(i);
                if (tableJoin.table1Alias == tableBlock.tableAlias || tableJoin.table2Alias == tableBlock.tableAlias) {
                    drawTableJoin(tableJoin, $("#" + tableJoin.tableJoinID)[0]);
                }

            }
        }
    };
    $(".canvas-box").on("dblclick", ".table-block h5", function (e) {
        // console.log("h5 dblclick");
        blockDoubleClick($(this).parent());
    });
    $(".canvas-box").on("dragstart", ".table-block", function (e) {
        // console.log("h5 dragstart");
        dragTypeEnum = 1;
        blockDragObject = {};
        blockDragObject.canvasTop = $("#daigramCanvas").offset().top;
        blockDragObject.canvasLeft = $("#daigramCanvas").offset().left;
        selectBlock($(this));
        $("#daigramCanvas").css({
            "cursor": "move"
        });
        blockDragObject.position = selectedBlockView.position();
        blockDragObject.titleLeft = e.originalEvent.pageX - blockDragObject.position.left - blockDragObject.canvasLeft;
        blockDragObject.titleTop = e.originalEvent.pageY - blockDragObject.position.top - blockDragObject.canvasTop;

        dragObjectStr = JSON.stringify(createBusinessObjectFolderByBlock(selectedBlockView));
        dragType = "folder";

        e.originalEvent.dataTransfer.setData(dragType, dragObjectStr);
        e.stopPropagation();
    });
    $("body").on("dragover",function(e){
        if (!$(e.target).hasClass("middle-content") && !$(e.target).parents().hasClass("middle-content")) {
            fieldDragObject.drawLine = false;
            fieldDragObject.tempPath.remove();
            dragTypeEnum = -1;
        }
    });
    $("body").on("dragend", ".table-block", function (e) {
        // console.log("block dragend");
        dragTypeEnum = -1;
        
    });
    $("body").on("mousedown", ".table-block", function (e) {
        selectBlock($(this));
    });
    $(".canvas-box").on("mousedown", ".table-block ul li.resize", function (e) {
        // console.log("resize mousedown");
        e.stopPropagation();
        let canvasTop = $("#daigramCanvas").offset().top;
        let canvasLeft = $("#daigramCanvas").offset().left;


        selectBlock($(this).parent().parent());
        let ulView = $(this).parent();
        let position = selectedBlockView.position();
        let blockID = selectedBlockView.attr("id");
        let tableBlock = mRelationDiagram.tableBlocks.item(blockID);


        let blockBorder = $("#blockBorder");
        let left = selectedBlockView.offset().left - canvasLeft;
        let top = selectedBlockView.offset().top - canvasTop;
        let titleHeight = tableBlock.tableAlias == tableBlock.table.tableName ? TITLE_HEIGHT1 : TITLE_HEIGHT2;
        let minHeight = titleHeight + FIELD_HEIGHT;
        let maxCount = parseInt(selectedBlockView.attr("maxFieldCount"));
        let maxHeight = titleHeight + maxCount * FIELD_HEIGHT;
        if (maxCount < tableBlock.table.tableFields.count()) {
            maxHeight += MORE_HEIGHT;
        }
        blockBorder.removeClass("box-hide").css({
            left: left - 1,
            top: top - 1,
            width: selectedBlockView.width(),
            height: selectedBlockView.height()
        });

        $(document.body).mousemove(function (e) {
            let height = e.pageY - canvasTop - top;
            if (height > maxHeight) {
                height = maxHeight;
            }
            if (height < minHeight) {
                height = minHeight;
            }
            blockBorder.css({
                height: height
            });
        });

        $(document.body).mouseup(function (e) {
            blockBorder.addClass("box-hide");
            $(document.body).off('mouseup');
            $(document.body).off('mousemove');
            let endY = e.pageY - canvasTop;
            let h = endY - position.top - ulView.position().top;
            let maxFieldCount = parseInt(selectedBlockView.attr("maxFieldCount"));
            let fieldCount = Math.min(Math.max(1, Math.round(h / FIELD_HEIGHT)), maxFieldCount);
            let showFieldCount = parseInt(selectedBlockView.attr("showFieldCount"));

            if (fieldCount != showFieldCount) {
                ulView.find("li.field").each(function () {
                    if ($(this).index() >= fieldCount) {
                        $(this).css({
                            "display": "none"
                        });
                    } else {
                        $(this).css({
                            "display": "block"
                        });
                    }
                });
                if (fieldCount >= tableBlock.table.tableFields.count()) {
                    ulView.find("li.more").css({
                        "display": "none"
                    });
                } else {
                    ulView.find("li.more").css({
                        "display": "block"
                    });
                }
                selectedBlockView.attr("showFieldCount", fieldCount);

                //重新绘制相关的tableJoins
                for (let i = 0; i < mRelationDiagram.tableJoins.count(); i++) {
                    let tableJoin = mRelationDiagram.tableJoins.item(i);
                    if (tableJoin.table1Alias == tableBlock.tableAlias || tableJoin.table2Alias == tableBlock.tableAlias) {
                        drawTableJoin(tableJoin, $("#" + tableJoin.tableJoinID)[0]);
                    }

                }
            }

        });
    });

}

function createBOByTableField(tableField, tableAlias) {
    let businessObject = new BusinessObject();
    businessObject.businessObjectID = new GUID().newGUID();
    if (useCommentAsName && tableField.comment) {
        businessObject.businessObjectName = getAppropriateName(tableField.comment);
    } else {
        businessObject.businessObjectName = getAppropriateName(tableField.fieldName);
    }
    businessObject.businessObjectFolderID = "-1";
    businessObject.visibility = 0;
    businessObject.aggregateFunction = false;
    businessObject.aggregateAware = false;
    businessObject.valueOrder = "";
    businessObject.formatString = "";
    businessObject.businessObjectType = tableField.dataType == 2 ? 1 : 0;
    businessObject.dataType = tableField.dataType;
    businessObject.columnName = "";
    businessObject.expressionText = `${tableAlias}.${tableField.fieldName}`;
    businessObject.expressionList = [`${tableAlias}.${tableField.fieldName}`];
    businessObject.tableNameList = [[tableAlias]];
    businessObject.sortIndex = 0;
    return businessObject;
}
/**
 * 根据表块生成业务对象分类
 */
function createBusinessObjectFolderByBlock(blockView) {
    let blockID = blockView.attr("id");
    let tableBlock = mRelationDiagram.tableBlocks.item(blockID);
    let businessObjectFolder = new BusinessObjectFolder();
    businessObjectFolder.folderID = new GUID().newGUID();
    businessObjectFolder.folderName = tableBlock.tableAlias;
    businessObjectFolder.description = "";
    businessObjectFolder.folderParentID = "-1";
    businessObjectFolder.visibility = 0;
    businessObjectFolder.sortIndex = 0;

    let businessObjects = new BusinessObjects();
    let tableFields = tableBlock.table.tableFields;
    for (let i = 0; i < tableFields.count(); i++) {
        let businessObject = createBOByTableField(tableFields.item(i), tableBlock.tableAlias);
        businessObject.businessObjectFolderID = businessObjectFolder.folderID;
        businessObjects.add(businessObject);
    }
    return { folder: businessObjectFolder, objects: businessObjects };
}

function insertTables(tables) {
    tables.getTableFields(mDatabaseLink.dataSourceID, false, function () {
        let col = 0;
        let row = 0;

        for (let i = 0; i < tables.count(); i++) {
            let table = tables.item(i);
            let tableBlock = new TableBlock();
            tableBlock.tableBlockID = new GUID().newGUID();
            let alias = getAppropriateName(table.tableName);
            if (mRelationDiagram.relationDiagramType == 0) {
                alias = mRelationModel.getDimensionDiagrams().getDefaultTableAlias(alias);
            } else {
                alias = mRelationDiagram.getDefaultTableAlias(alias);
            }
            tableBlock.tableAlias = alias;
            tableBlock.table = table;
            tableBlock.x = 100 + col * 150;
            tableBlock.y = 100 + row * 300;
            tableBlock.height = 1000000000;
            mRelationDiagram.tableBlocks.add(tableBlock);
            drawTableBlock(tableBlock);
            col++;
            if (col > 5) {
                row++;
                col = 0;
            }
        }
    }, function (errorMsg) { });
}

function selectBlock(blockView) {
    unselectBlock();
    unselectJoin();

    blockView.addClass("block-selected");
    selectedBlockView = blockView;

    $("#btnDeleteTableOrTableJoins").addClass("button-color");
}

function selectJoin(joinView) {
    unselectBlock();
    unselectJoin();

    joinView[0].setAttribute("class", "table-join join-selected");
    selectedJoinView = joinView;

    $("#btnTableJoinsAttribute").addClass("button-color");
    $("#btnDeleteTableOrTableJoins").addClass("button-color");
}

function unselectBlock() {
    if (selectedBlockView != null) {
        selectedBlockView.removeClass("block-selected");
        selectedBlockView = null;

        $("#btnDeleteTableOrTableJoins").addClass("button-color");
    }
}
function unselectJoin() {
    if (selectedJoinView != null) {
        selectedJoinView[0].setAttribute("class", "table-join");
        selectedJoinView = null;

        $("#btnTableJoinsAttribute").addClass("button-color");
        $("#btnDeleteTableOrTableJoins").addClass("button-color");
    }
}

function blockDoubleClick(selectedBlockView) {
    let blockID = selectedBlockView.attr("id");
    let tableBlock = mRelationDiagram.tableBlocks.item(blockID);

    let maxFieldCount = parseInt(selectedBlockView.attr("maxFieldCount"));
    let showFieldCount = parseInt(selectedBlockView.attr("showFieldCount"));

    if (showFieldCount == maxFieldCount) {
        selectedBlockView.attr("showFieldCount", "1");
        selectedBlockView.find("ul li.field").each(function () {
            if ($(this).index() > 0) {
                $(this).css({
                    "display": "none"
                });
            }
        });
        if (maxFieldCount > 1) {
            selectedBlockView.find("ul li.more").css({
                "display": "block"
            });
        }

    } else {
        selectedBlockView.attr("showFieldCount", maxFieldCount);
        selectedBlockView.find("ul li.field").each(function () {
            $(this).css({
                "display": "block"
            });
        });
        if (maxFieldCount == tableBlock.table.tableFields.count()) {
            selectedBlockView.find("ul li.more").css({
                "display": "none"
            });
        }
    }
    //重新绘制相关的tableJoins
    for (let i = 0; i < mRelationDiagram.tableJoins.count(); i++) {
        let tableJoin = mRelationDiagram.tableJoins.item(i);
        if (tableJoin.table1Alias == tableBlock.tableAlias || tableJoin.table2Alias == tableBlock.tableAlias) {
            drawTableJoin(tableJoin, $("#" + tableJoin.tableJoinID)[0]);
        }

    }
}

export { initRelationDiagram };